//		05/14/15 Driver for LTC2335 family of 8ch SAR ADCs
//GMH
`timescale 1ps / 1ps
module RevA
(
	CSB_33,
	CLK,
	CNVCLK,
	SDO0,
	SDO1,
	SDO2,
	SDO3,
	SDO4,
	SDO5,
	SDO6,
	SDO7,
	SCK_33,
	BUSY_33,
	DB2,
	DB3,
	DB4,
	DB5,
	DB6,
	DB7,
	DB8,
	DB9,
	DB10,
	DB14,
	DB15,
	DB16,
	DB17,
	DB0,
	DB1,
	DB11,
	DB12,
	DB13,
	WRIN,
	WRIN2,
	B16_18L,
	SCK_IN,
	SCK_OUT,
	SDI_33,
	SDIIN,
	SCKIN,
	CNVIN,
	ID,
	IDOUT,
	A2,
	A1,
	A0,
	SS2,
	SS1,
	SS0,
	LVDS_CMOS_IN,
	LVDS_CMOS_IN_JP3,
	LVDS_CMOS_OUTPUT,
	AUX0,
	AUX1,
	d_latch_out,
	master_clk_out,
	master_clkd_out,
	data_latch_start,
	sdo_count,
	data_latch_out
);
output 			d_latch_out;								// pin 7
output			data_latch_out;							// pin 74
output			data_latch_start;							// pin 72
output [3:0]	sdo_count;									// pins64-67
output			master_clk_out;							// pin 10
output			master_clkd_out;							// pin 11
output			IDOUT;										// pin 114 	not used
output			A2;											// pin 111
output			A1;											// pin 110	A2-A0 give PScope address info on last ADC conversion
output			A0;											// pin 106
output			SS2;											// pin 105
output			SS1;											// pin 104	SS2-SS0 give PScope SoftSpan Range info on last ADC conversion
output			SS0;											// pin 100
output			CSB_33;										// pin 77 	CSB_33 is unsynchronized CONV signal.  
input				ID;											// pin 73	not used
input          WRIN;											// pin 85	if WRIN=1 CPLD controls ADC
input				WRIN2;										// pin 3		if WRIN2=0 sneakerport controls ADC both can be disabled if externalcontrol is desired (QuikEval Controller)
input				SDIIN;										// pin 84	\
input				SCKIN;										// pin 83	 | use these to generate config word from DC890 virtual SPI. Handled by external devices on DC2412
input				CNVIN;										// pin 80	/	These are not used currently
input				LVDS_CMOS_IN;								// pin 4		from virtual SPI
input				LVDS_CMOS_IN_JP3;							// pin 79	from JP3
input				AUX0;											// pin 1		not used 
input				AUX1;											// pin 2		not used
output			LVDS_CMOS_OUTPUT;							// pin 79	to ADC
input				CLK;											// pin 25	Clock from DC2412. Clock is divided by 82 to set conv rate
output			CNVCLK;										// pin 121	CNVCLK to PScope at conv rate
output			SDO0;											//				SDO0-SDO3 ground these 
output			SDO1;
output			SDO2;
output			SDO3;
input				SDO4;											// pin 49	SDO from LTC2335
output			SDO5;											//				SDO5-SDO7 ground these
output			SDO6;
output			SDO7;
inout				SCK_33;										// pin 59	SCK to LTC2335
inout       	SDI_33;										// pin 30	SDI to LTC2335
input       	SCK_IN;										//				Not used 
input      		SCK_OUT;										//				SCK_OUT from LTC2335 both edges used to clk data
input				BUSY_33;										// pin 28  	BUSY from LTC2335 not used
output			DB2;											// pin 124
output			DB3;											// pin 125
output			DB4;											// pin 126
output			DB5;											// pin 127
output			DB6;											// pin 144
output			DB7;											// pin 143
output			DB8;											// pin 142
output			DB9;											// pin 141
output			DB10;											// pin 138 	DB0-DB17 deserialized data from LTC2335
output			DB14;											// pin 133
output			DB15;											// pin 132
output			DB16;											// pin 129
output			DB17;											// pin 128
output			DB0;											// pin 115
output			DB1;											// pin 119
output			DB11;											// pin 137
output			DB12;											// pin 136
output			DB13;											// pin 135
input				B16_18L;										// pin 75  	16bit/18bit detect 1=16 0=18
parameter 		CLR = 1'b0,
					SET = 1'b1,
					op = 1'b1,
					ip = 1'b0;	
wire [3:0] sdo_count;										
wire data_latch_start;
wire master_clk;												//same as CLK
wire [23:0] dout;
wire SDIIN;														//added 2/7/14
wire SCKIN;														//added 2/7/14
wire CNVIN;														//added 2/7/14
wire WRIN;														//added 2/7/14
wire WRIN2;														//added 2/7/14
wire LVDS_CMOS_IN;											//added 2/7/14				
wire LVDS_CMOS_IN_JP3;										//added 2/7/14
wire LVDS_CMOS_OUTPUT;										//added 2/7/14

assign LVDS_CMOS_OUTPUT = 1'b0;							// modified 04/06/15 forces LVDS/CMOS pin on ADC to CMOS position

wire SDO0;														//added 4/21/14
wire SDO1;
wire SDO2;
wire SDO3;
wire SDO4;
wire SDO5;
wire SDO6;
wire SDO7;

assign SDO0 =1'b0;
assign SDO1 =1'b0;
assign SDO2 =1'b0;
assign SDO3 =1'b0;
assign SDO5 =1'b0;
assign SDO6 =1'b0;
assign SDO7 =1'b0;

reg [11:0]sdoO4;
reg [11:0]sdoE4;
wire [23:0]sdo4;
wire mosi;
wire aux0;
wire conv;
wire sck;
wire B34;
wire B30;
wire data_latch;																						
wire master_clk_0 /* synthesis keep */;				
wire master_clk_1 /* synthesis keep */;
wire master_clk_2 /* synthesis keep */;
wire master_clk_3 /* synthesis keep */;
wire master_clk_4 /* synthesis keep */;
wire master_clk_5 /* synthesis keep */;
wire master_clk_6 /* synthesis keep */;
wire master_clk_7 /* synthesis keep */;
wire master_clk_8 /* synthesis keep */;
wire master_clk_9 /* synthesis keep */;
wire master_out_0; //preserve
wire master_out_1; //preserve
wire master_out_2; //preserve
wire master_out_3; //preserve
wire master_out_4; //preserve
wire master_out_5; //preserve
wire master_out_6; //preserve
wire master_out_7; //preserve
wire master_out_8; //preserve
wire master_out_9; //preserve
wire master_clk_10 /* synthesis keep */;										
wire master_clk_11 /* synthesis keep */;
wire master_clk_12 /* synthesis keep */;
wire master_clk_13 /* synthesis keep */;
wire master_clk_14 /* synthesis keep */;
wire master_clk_15 /* synthesis keep */;
wire master_clk_16 /* synthesis keep */;
wire master_clk_17 /* synthesis keep */;
wire master_clk_18 /* synthesis keep */;
wire master_clk_19 /* synthesis keep */;
wire master_out_10; //preserve
wire master_out_11; //preserve
wire master_out_12; //preserve
wire master_out_13; //preserve
wire master_out_14; //preserve
wire master_out_15; //preserve
wire master_out_16; //preserve
wire master_out_17; //preserve
wire master_out_18; //preserve
wire master_out_19; //preserve
wire miso0;
wire miso1;
wire miso2;
wire miso3;
wire miso4;
wire miso5;
wire miso6;
wire miso7;
reg DB0;
reg DB1;
reg DB2;
reg DB3;
reg DB4;
reg DB5;														
reg DB6;
reg DB7;
reg DB8;
reg DB9;
reg DB10;
reg DB11;
reg DB12;
reg DB13;
reg DB14;
reg DB15;
reg DB16;
reg DB17;
reg A2;
reg A1;
reg A0;
reg SS2;
reg SS1;
reg SS0;
														
wire BUSY_33;
wire CNVCLK;
reg clkdiv2;
wire clkout_latch;																	
wire d_latch;
wire B16_18L;
wire ID;
wire IDOUT;																			
wire SCK_IN;
wire SCK_OUT;
wire numbits;
assign dout = sdo4;
assign numbits = B16_18L;									//use to set data direction and pin assignments 1=16bits 0=18bits

assign IDOUT = ID;											// ID is pulled high. ID is not used on this board.
    always @(posedge d_latch )begin//	 				//	changed 11/21/13 was negedge d_latch					      					    														
				if (numbits==1) begin////
					DB17 <= dout[23];
					DB16 <= dout[22];
					DB15 <= dout[21];
					DB14 <= dout[20];
					DB13 <= dout[19];
					DB12 <= dout[18];
					DB11 <= dout[17];
					DB10 <= dout[16];
					DB9 <= dout[15];
					DB8 <= dout[14];
					DB7 <= dout[13];
					DB6 <= dout[12];
					DB5 <= dout[11];
					DB4 <= dout[10];
					DB3 <= dout[9];
					DB2 <= dout[8];
					A2 <= dout[5];
					A1 <= dout[4];
					A0 <= dout[3];
					SS2 <= dout[2];
					SS1 <= dout[1];
					SS0 <= dout[0];
					DB1 <= dout[7];
					DB0 <= dout[6];									// 16bit dout[7] and dout[6] are always 0 for 16-bit parts
				end////	    
				else begin////
					DB17 <= dout[23];
					DB16 <= dout[22];
					DB15 <= dout[21];
					DB14 <= dout[20];
					DB13 <= dout[19];
					DB12 <= dout[18];
					DB11 <= dout[17];
					DB10 <= dout[16];
					DB9 <= dout[15];
					DB8 <= dout[14];
					DB7 <= dout[13];
					DB6 <= dout[12];
					DB5 <= dout[11];
					DB4 <= dout[10];
					DB3 <= dout[9];
					DB2 <= dout[8];
					DB1 <= dout[7];
					DB0 <= dout[6];							// 18bit
					A2 <= dout[5];
					A1 <= dout[4];
					A0 <= dout[3];
					SS2 <= dout[2];
					SS1 <= dout[1];
					SS0 <= dout[0];
					
				end////
    end//

assign master_clk = CLK & WRIN;						  	//CLK active when WRIN is high.
assign master_clk_0 = ~master_clk;
assign master_clk_1 = ~master_clk_0;
assign master_clk_2 = ~master_clk_1;
assign master_clk_3 = ~master_clk_2;
assign master_clk_4 = ~master_clk_3;
assign master_clk_5 = ~master_clk_4;
assign master_clk_6 = ~master_clk_5;
assign master_clk_7 = ~master_clk_6;
assign master_clk_8 = ~master_clk_7;
assign master_clk_9 = ~master_clk_8;
assign master_clk_10 = ~master_clk_9;
assign master_clk_11 = ~master_clk_10;
assign master_clk_12 = ~master_clk_11;
assign master_clk_13 = ~master_clk_12;
assign master_clk_14 = ~master_clk_13;
assign master_clk_15 = ~master_clk_14;
assign master_clk_16 = ~master_clk_15;
assign master_clk_17 = ~master_clk_16;
assign master_clk_18 = ~master_clk_17;
assign master_clk_19 = ~master_clk_18;
assign sdo4 = {sdoO4[11],sdoE4[11],sdoO4[10],sdoE4[10],sdoO4[9],sdoE4[9],sdoO4[8],sdoE4[8],sdoO4[7],sdoE4[7],sdoO4[6],sdoE4[6],sdoO4[5],sdoE4[5],sdoO4[4],sdoE4[4],sdoO4[3],sdoE4[3],sdoO4[2],sdoE4[2],sdoO4[1],sdoE4[1],sdoO4[0],sdoE4[0]};

always @(posedge SCK_OUT) begin 							// SCK_OUT 1/2 master clk frequency
	sdoO4 <= {sdoO4[10:0],SDO4};
end 

always @(negedge SCK_OUT) begin 							// SCK_OUT 1/2 master clk frequency
	sdoE4 <= {sdoE4[10:0],SDO4};
end 

assign sdo_count= 4'b0000;
assign data_latch_start = 1'b0;												
assign CSB_33 = ~conv ;		
assign data_latch_out = data_latch;			
assign d_latch = data_latch & master_clk_1 ;			//5/12/14 was master_clk ,    on posedge DB0-DB17,A0-A2 and SS0-SS2 are updated. delayed version of data_latch_start 
assign d_latch_out = d_latch;					   		//d_latch to outside world
assign master_clk_out = master_clk;	
assign master_clkd_out = master_clk_15;							
assign CNVCLK =  data_latch & master_clk_17;			//5/12/14 was master_clk_13  tell DC890 when to grab data. grab on neg edge.		delayed version of d_latch							

dff dff1(.d(1'b0), .clk(CLK), .clrn(1'b1), .prn(~data_latch), .q(clkout_latch));
dff dffmc0(.d(1'b0), .clk(master_clk_0), .clrn(1'b1), .prn(1'b1), .q(master_out_0));
dff dffmc1(.d(1'b0), .clk(master_clk_1), .clrn(1'b1), .prn(1'b1), .q(master_out_1));
dff dffmc2(.d(1'b0), .clk(master_clk_2), .clrn(1'b1), .prn(1'b1), .q(master_out_2));
dff dffmc3(.d(1'b0), .clk(master_clk_3), .clrn(1'b1), .prn(1'b1), .q(master_out_3));
dff dffmc4(.d(1'b0), .clk(master_clk_4), .clrn(1'b1), .prn(1'b1), .q(master_out_4));
dff dffmc5(.d(1'b0), .clk(master_clk_5), .clrn(1'b1), .prn(1'b1), .q(master_out_5));
dff dffmc6(.d(1'b0), .clk(master_clk_6), .clrn(1'b1), .prn(1'b1), .q(master_out_6));
dff dffmc7(.d(1'b0), .clk(master_clk_7), .clrn(1'b1), .prn(1'b1), .q(master_out_7));
dff dffmc8(.d(1'b0), .clk(master_clk_8), .clrn(1'b1), .prn(1'b1), .q(master_out_8));
dff dffmc9(.d(1'b0), .clk(master_clk_9), .clrn(1'b1), .prn(1'b1), .q(master_out_9));

dff dffmc10(.d(1'b0), .clk(master_clk_10), .clrn(1'b1), .prn(1'b1), .q(master_out_10));
dff dffmc11(.d(1'b0), .clk(master_clk_11), .clrn(1'b1), .prn(1'b1), .q(master_out_11));
dff dffmc12(.d(1'b0), .clk(master_clk_12), .clrn(1'b1), .prn(1'b1), .q(master_out_12));
dff dffmc13(.d(1'b0), .clk(master_clk_13), .clrn(1'b1), .prn(1'b1), .q(master_out_13));
dff dffmc14(.d(1'b0), .clk(master_clk_14), .clrn(1'b1), .prn(1'b1), .q(master_out_14));
dff dffmc15(.d(1'b0), .clk(master_clk_15), .clrn(1'b1), .prn(1'b1), .q(master_out_15));
dff dffmc16(.d(1'b0), .clk(master_clk_16), .clrn(1'b1), .prn(1'b1), .q(master_out_16));
dff dffmc17(.d(1'b0), .clk(master_clk_17), .clrn(1'b1), .prn(1'b1), .q(master_out_17));
dff dffmc18(.d(1'b0), .clk(master_clk_18), .clrn(1'b1), .prn(1'b1), .q(master_out_18));
dff dffmc19(.d(1'b0), .clk(master_clk_19), .clrn(1'b1), .prn(1'b1), .q(master_out_19));
									
serial_io io_2(.master_clk		(master_clk),	   	//clk in from DC2412
					.mosi	 	   	(mosi), 	   	   	//sdi to 2335
					.sck		 		(sck),		   		//sck to 2335 
					.conv	 	   	(conv),		   		//conv or conv_gate to 2335
					.aux0	 	   	(aux0), 		   		//aux signal not used for all parts
					.mcd				(master_clk_1),		//delayed version of master_clk //5/9/14 was master_clk_3
					.B16_18L			(B16_18L),				//16-bit/18-bit select
					.WRIN				(WRIN),					//if WRIN=1 CPLD controls ADC, if WRIN=0 sneakerport controls ADC
					.d_latch			(data_latch)			//latches data to DC890
			);
			
 alt_iobuf														//primitive for CycloneIII IO pin
 d_bit_34		(.i  				(sck),					//serial_clk_out to ADC
					.oe  				(WRIN),					//WRIN=1 SCK_33=sck, WRIN=0 SCK_33=HiZ
					.o 				(B34),					//
					.io  				(SCK_33));				//IO pin
// defparam d_bit_34.operation_mode = "bidir";
 
 alt_iobuf														//primitive for CycloneIII IO pin
 d_bit_30		(.i  				(mosi),					//master_out_slave_in (to ADC SDI pin)
					.oe  				(WRIN),					//WRIN=1 SDI_33=sdi, WRIN=0 SDI_33=HiZ
					.o 				(B30),					//
					.io  				(SDI_33));				//IO pin
// defparam d_bit_30.operation_mode = "bidir";
 

endmodule

